IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Seg_Audit') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Seg_Audit 
END
GO

CREATE PROCEDURE CPJ_Seg_Audit @pJsonRecibido VARCHAR(MAX)
AS 

SET NOCOUNT ON
DECLARE	@pId_Seg_User_Audit	BIGINT,
		@pProcedimiento		VARCHAR(50) ,
		@pNombre_Vent		VARCHAR(1000) ,
		@pId_Usuario		SMALLINT ,
		@pAccion			TINYINT ,
		@pId_Trans			INT ,
		@pId_Cliente		INT ,
		@pId_Producto		VARCHAR(14) ,
		@pId_Proveedor		INT ,
		@pId_Valor			INT ,
		@pId_Parametro		VARCHAR(20) ,
		@pAccion_Salida		TINYINT ,
		@pValor_Parametro	VARCHAR(1000) ,
		@pFlag_QA			CHAR(1) ,
		@pAnalisis			VARCHAR(30) ,
		@pFecha_Venc		DATETIME ,
		@pFecha_Caducidad	DATETIME ,
		@pLote				VARCHAR(20) 

DECLARE	@query				VARCHAR(8000),
		@Id_Seg_User_Audit_String VARCHAR(20)


SET @Id_Seg_User_Audit_String		= ISNULL(CONVERT(VARCHAR(20),		dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Seg_User_Audit')),'')
IF ISNUMERIC(@Id_Seg_User_Audit_String) = 1
	SET @pId_Seg_User_Audit		= ISNULL(CONVERT(BIGINT,@Id_Seg_User_Audit_String),0)
ELSE
	SET @pId_Seg_User_Audit		= 0
	
SET @pProcedimiento			= ISNULL(CONVERT(VARCHAR(100),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Procedimiento')),'')
SET @pNombre_Vent			= ISNULL(CONVERT(VARCHAR(100),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Nombre_Vent')),'')
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT,		dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')),0)
SET @pAccion				= ISNULL(CONVERT(TINYINT,		dbo.CF_JSON_VALUE(@pJsonRecibido,'Accion')),0)
SET @pId_Trans				= ISNULL(CONVERT(INT,			dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Trans')),0)
SET @pId_Cliente			= ISNULL(CONVERT(INT,			dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')),0)
SET @pId_Producto			= ISNULL(CONVERT(VARCHAR(14),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Producto')),'')
SET @pId_Proveedor			= ISNULL(CONVERT(INT,			dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Proveedor')),0)
SET @pId_Valor				= ISNULL(CONVERT(INT,			dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Valor')),0)
SET @pId_Parametro			= ISNULL(CONVERT(VARCHAR(20),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Parametro')),'')
SET @pAccion_Salida			= ISNULL(CONVERT(TINYINT,		dbo.CF_JSON_VALUE(@pJsonRecibido,'Accion_Salida')),0)
SET @pValor_Parametro		= ISNULL(CONVERT(VARCHAR(1000),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Valor_Parametro')),'')
SET @pFlag_QA				= ISNULL(CONVERT(CHAR(1),		dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_QA')),'')
SET @pAnalisis				= ISNULL(CONVERT(VARCHAR(30),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Analisis')),'')
SET @pFecha_Venc			= CONVERT(DATETIME,				dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Venc'))
SET @pFecha_Caducidad		= CONVERT(DATETIME,				dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Caducidad'))
SET @pLote					= ISNULL(CONVERT(VARCHAR(20),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Lote')),'')



IF @pId_Seg_User_Audit = 0
BEGIN
	INSERT INTO Seg_Usuarios_Audit (
			Fecha,Procedimiento,Nombre_Vent,Id_Usuario,Accion,Id_Trans,Id_Cliente,Id_Producto,Id_Proveedor,Id_Valor			
			,Id_Parametro,Accion_Salida,Valor_Parametro,Flag_QA,Analisis,Fecha_Venc,Fecha_Caducidad,Lote)
			VALUES (
			GETDATE(),@pProcedimiento,@pNombre_Vent,@pId_Usuario,@pAccion,@pId_Trans,@pId_Cliente,@pId_Producto,@pId_Proveedor,@pId_Valor			
			,@pId_Parametro,@pAccion_Salida,@pValor_Parametro,@pFlag_QA,@pAnalisis,@pFecha_Venc,@pFecha_Caducidad,@pLote)
	SELECT @@IDENTITY
	RETURN 0
END
ELSE
BEGIN
	UPDATE Seg_Usuarios_Audit SET Fecha_Salida = GETDATE() , Accion_Salida = @pAccion_Salida 
		WHERE Id_Seg_User_Audit = @pId_Seg_User_Audit
	SELECT @pId_Seg_User_Audit
	RETURN 0
END



RETURN
	

	/*

EXEC CPJ_Seg_Audit '{	"Id_Seg_User_Audit":"",
						"Procedimiento":"Main",
						"Nombre_Vent":"",
						"Id_Usuario":"",
						"Accion":"",
						"Id_Trans":"",
						"Id_Cliente":"",
						"Id_Producto":"",
						"Id_Proveedor":"",
						"Id_Valor":"",
						"Id_Parametro":"",
						"Accion_Salida":"",
						"Valor_Parametro":"",
						"Flag_QA":"",
						"Analisis":"",
						"Fecha_Venc":"",
						"Fecha_Caducidad":"",
						"Lote":""}



	*/
	

